/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.network;

import com.technicalitiesmc.lib.init.TKLibIFOs;
import com.technicalitiesmc.lib.item.ifo.IFOManager;
import com.technicalitiesmc.lib.item.ifo.ItemFunctionalOverride;
import com.technicalitiesmc.lib.network.Packet;
import com.technicalitiesmc.lib.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundEnableIFOPacket
implements Packet {
    private final ItemFunctionalOverride ifo;

    public ClientboundEnableIFOPacket(ItemFunctionalOverride ifo) {
        this.ifo = ifo;
    }

    public ClientboundEnableIFOPacket(FriendlyByteBuf buf) {
        ResourceLocation key = new ResourceLocation(buf.m_130277_());
        ItemFunctionalOverride.Type type = (ItemFunctionalOverride.Type)TKLibIFOs.FORGE_REGISTRY.get().getValue(key);
        this.ifo = type.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.ifo.type().getRegistryName().toString());
        this.ifo.writeToNetwork(buf);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Player player = Utils.getClientPlayer();
            if (player != null) {
                IFOManager.enable(player, this.ifo);
            }
        });
        return true;
    }
}

